.SS CHECKSUM
This target allows to selectively work around broken/old applications.
It can only be used in the mangle table.
.TP
\fB\-\-checksum\-fill\fP
Compute and fill in the checksum in a packet that lacks a checksum.
This is particularly useful, if you need to work around old applications
such as dhcp clients, that do not work well with checksum offloads,
but don't want to disable checksum offload in your device.
.SS CLASSIFY
This module allows you to set the skb\->priority value (and thus classify the packet into a specific CBQ class).
.TP
\fB\-\-set\-class\fP \fImajor\fP\fB:\fP\fIminor\fP
Set the major and minor class value. The values are always interpreted as
hexadecimal even if no 0x prefix is given.
.SS CONNMARK
This module sets the netfilter mark value associated with a connection. The
mark is 32 bits wide.
.TP
\fB\-\-set\-xmark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zero out the bits given by \fImask\fP and XOR \fIvalue\fP into the ctmark.
.TP
\fB\-\-save\-mark\fP [\fB\-\-nfmask\fP \fInfmask\fP] [\fB\-\-ctmask\fP \fIctmask\fP]
Copy the packet mark (nfmark) to the connection mark (ctmark) using the given
masks. The new nfmark value is determined as follows:
.IP
ctmark = (ctmark & ~ctmask) ^ (nfmark & nfmask)
.IP
i.e. \fIctmask\fP defines what bits to clear and \fInfmask\fP what bits of the
nfmark to XOR into the ctmark. \fIctmask\fP and \fInfmask\fP default to
0xFFFFFFFF.
.TP
\fB\-\-restore\-mark\fP [\fB\-\-nfmask\fP \fInfmask\fP] [\fB\-\-ctmask\fP \fIctmask\fP]
Copy the connection mark (ctmark) to the packet mark (nfmark) using the given
masks. The new ctmark value is determined as follows:
.IP
nfmark = (nfmark & ~\fInfmask\fP) ^ (ctmark & \fIctmask\fP);
.IP
i.e. \fInfmask\fP defines what bits to clear and \fIctmask\fP what bits of the
ctmark to XOR into the nfmark. \fIctmask\fP and \fInfmask\fP default to
0xFFFFFFFF.
.IP
\fB\-\-restore\-mark\fP is only valid in the \fBmangle\fP table.
.PP
The following mnemonics are available for \fB\-\-set\-xmark\fP:
.TP
\fB\-\-and\-mark\fP \fIbits\fP
Binary AND the ctmark with \fIbits\fP. (Mnemonic for \fB\-\-set\-xmark
0/\fP\fIinvbits\fP, where \fIinvbits\fP is the binary negation of \fIbits\fP.)
.TP
\fB\-\-or\-mark\fP \fIbits\fP
Binary OR the ctmark with \fIbits\fP. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fP\fB/\fP\fIbits\fP.)
.TP
\fB\-\-xor\-mark\fP \fIbits\fP
Binary XOR the ctmark with \fIbits\fP. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fP\fB/0\fP.)
.TP
\fB\-\-set\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Set the connection mark. If a mask is specified then only those bits set in the
mask are modified.
.TP
\fB\-\-save\-mark\fP [\fB\-\-mask\fP \fImask\fP]
Copy the nfmark to the ctmark. If a mask is specified, only those bits are
copied.
.TP
\fB\-\-restore\-mark\fP [\fB\-\-mask\fP \fImask\fP]
Copy the ctmark to the nfmark. If a mask is specified, only those bits are
copied. This is only valid in the \fBmangle\fP table.
.SS CONNSECMARK
This module copies security markings from packets to connections
(if unlabeled), and from connections back to packets (also only
if unlabeled).  Typically used in conjunction with SECMARK, it is
only valid in the
.B mangle
table.
.TP
\fB\-\-save\fP
If the packet has a security marking, copy it to the connection
if the connection is not marked.
.TP
\fB\-\-restore\fP
If the packet does not have a security marking, and the connection
does, copy the security marking from the connection to the packet.

.SS CT
The CT target allows to set parameters for a packet or its associated
connection. The target attaches a "template" connection tracking entry to
the packet, which is then used by the conntrack core when initializing
a new ct entry. This target is thus only valid in the "raw" table.
.TP
\fB\-\-notrack\fP
Disables connection tracking for this packet.
.TP
\fB\-\-helper\fP \fIname\fP
Use the helper identified by \fIname\fP for the connection. This is more
flexible than loading the conntrack helper modules with preset ports.
.TP
\fB\-\-ctevents\fP \fIevent\fP[\fB,\fP...]
Only generate the specified conntrack events for this connection. Possible
event types are: \fBnew\fP, \fBrelated\fP, \fBdestroy\fP, \fBreply\fP,
\fBassured\fP, \fBprotoinfo\fP, \fBhelper\fP, \fBmark\fP (this refers to
the ctmark, not nfmark), \fBnatseqinfo\fP, \fBsecmark\fP (ctsecmark).
.TP
\fB\-\-expevents\fP \fIevent\fP[\fB,\fP...]
Only generate the specified expectation events for this connection.
Possible event types are: \fBnew\fP.
.TP
\fB\-\-zone\fP \fIid\fP
Assign this packet to zone \fIid\fP and only have lookups done in that zone.
By default, packets have zone 0.
.SS DSCP
This target allows to alter the value of the DSCP bits within the TOS
header of the IPv4 packet.  As this manipulates a packet, it can only
be used in the mangle table.
.TP
\fB\-\-set\-dscp\fP \fIvalue\fP
Set the DSCP field to a numerical value (can be decimal or hex)
.TP
\fB\-\-set\-dscp\-class\fP \fIclass\fP
Set the DSCP field to a DiffServ class.
.SS HL
This is used to modify the Hop Limit field in IPv6 header. The Hop Limit field
is similar to what is known as TTL value in IPv4.  Setting or incrementing the
Hop Limit field can potentially be very dangerous, so it should be avoided at
any cost. This target is only valid in
.B mangle
table.
.PP
.B Don't ever set or increment the value on packets that leave your local network!
.TP
\fB\-\-hl\-set\fP \fIvalue\fP
Set the Hop Limit to `value'.
.TP
\fB\-\-hl\-dec\fP \fIvalue\fP
Decrement the Hop Limit `value' times.
.TP
\fB\-\-hl\-inc\fP \fIvalue\fP
Increment the Hop Limit `value' times.
.SS IDLETIMER
This target can be used to identify when interfaces have been idle for a
certain period of time.  Timers are identified by labels and are created when
a rule is set with a new label.  The rules also take a timeout value (in
seconds) as an option.  If more than one rule uses the same timer label, the
timer will be restarted whenever any of the rules get a hit.  One entry for
each timer is created in sysfs.  This attribute contains the timer remaining
for the timer to expire.  The attributes are located under the xt_idletimer
class:
.PP
/sys/class/xt_idletimer/timers/<label>
.PP
When the timer expires, the target module sends a sysfs notification to the
userspace, which can then decide what to do (eg. disconnect to save power).
.TP
\fB\-\-timeout\fP \fIamount\fP
This is the time in seconds that will trigger the notification.
.TP
\fB\-\-label\fP \fIstring\fP
This is a unique identifier for the timer.  The maximum length for the
label string is 27 characters.
.SS LOG
Turn on kernel logging of matching packets.  When this option is set
for a rule, the Linux kernel will print some information on all
matching packets (like most IPv6 IPv6-header fields) via the kernel log
(where it can be read with
.I dmesg
or 
.IR syslogd (8)).
This is a "non-terminating target", i.e. rule traversal continues at
the next rule.  So if you want to LOG the packets you refuse, use two
separate rules with the same matching criteria, first using target LOG
then DROP (or REJECT).
.TP
\fB\-\-log\-level\fP \fIlevel\fP
Level of logging (numeric or see \fIsyslog.conf\fP(5)).
.TP
\fB\-\-log\-prefix\fP \fIprefix\fP
Prefix log messages with the specified prefix; up to 29 letters long,
and useful for distinguishing messages in the logs.
.TP
\fB\-\-log\-tcp\-sequence\fP
Log TCP sequence numbers. This is a security risk if the log is
readable by users.
.TP
\fB\-\-log\-tcp\-options\fP
Log options from the TCP packet header.
.TP
\fB\-\-log\-ip\-options\fP
Log options from the IPv6 packet header.
.TP
\fB\-\-log\-uid\fP
Log the userid of the process which generated the packet.
.SS MARK
This target is used to set the Netfilter mark value associated with the packet.
It can, for example, be used in conjunction with routing based on fwmark (needs
iproute2). If you plan on doing so, note that the mark needs to be set in the
PREROUTING chain of the mangle table to affect routing.
The mark field is 32 bits wide.
.TP
\fB\-\-set\-xmark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fP and XORs \fIvalue\fP into the packet
mark ("nfmark"). If \fImask\fP is omitted, 0xFFFFFFFF is assumed.
.TP
\fB\-\-set\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fP and ORs \fIvalue\fP into the packet
mark. If \fImask\fP is omitted, 0xFFFFFFFF is assumed.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-mark\fP \fIbits\fP
Binary AND the nfmark with \fIbits\fP. (Mnemonic for \fB\-\-set\-xmark
0/\fP\fIinvbits\fP, where \fIinvbits\fP is the binary negation of \fIbits\fP.)
.TP
\fB\-\-or\-mark\fP \fIbits\fP
Binary OR the nfmark with \fIbits\fP. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fP\fB/\fP\fIbits\fP.)
.TP
\fB\-\-xor\-mark\fP \fIbits\fP
Binary XOR the nfmark with \fIbits\fP. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fP\fB/0\fP.)
.SS NFLOG
This target provides logging of matching packets. When this target is
set for a rule, the Linux kernel will pass the packet to the loaded
logging backend to log the packet. This is usually used in combination
with nfnetlink_log as logging backend, which will multicast the packet
through a
.IR netlink
socket to the specified multicast group. One or more userspace processes
may subscribe to the group to receive the packets. Like LOG, this is a
non-terminating target, i.e. rule traversal continues at the next rule.
.TP
\fB\-\-nflog\-group\fP \fInlgroup\fP
The netlink group (1 \- 2^32\-1) to which packets are (only applicable for
nfnetlink_log). The default value is 0.
.TP
\fB\-\-nflog\-prefix\fP \fIprefix\fP
A prefix string to include in the log message, up to 64 characters
long, useful for distinguishing messages in the logs.
.TP
\fB\-\-nflog\-range\fP \fIsize\fP
The number of bytes to be copied to userspace (only applicable for
nfnetlink_log). nfnetlink_log instances may specify their own
range, this option overrides it.
.TP
\fB\-\-nflog\-threshold\fP \fIsize\fP
Number of packets to queue inside the kernel before sending them
to userspace (only applicable for nfnetlink_log). Higher values
result in less overhead per packet, but increase delay until the
packets reach userspace. The default value is 1.
.BR
.SS NFQUEUE
This target is an extension of the QUEUE target. As opposed to QUEUE, it allows
you to put a packet into any specific queue, identified by its 16-bit queue
number.
It can only be used with Kernel versions 2.6.14 or later, since it requires
the
.B
nfnetlink_queue
kernel support. The \fBqueue-balance\fP option was added in Linux 2.6.31.
.TP
\fB\-\-queue\-num\fP \fIvalue\fP
This specifies the QUEUE number to use. Valid queue numbers are 0 to 65535. The default value is 0.
.PP
.TP
\fB\-\-queue\-balance\fP \fIvalue\fP\fB:\fP\fIvalue\fP
This specifies a range of queues to use. Packets are then balanced across the given queues.
This is useful for multicore systems: start multiple instances of the userspace program on
queues x, x+1, .. x+n and use "\-\-queue\-balance \fIx\fP\fB:\fP\fIx+n\fP".
Packets belonging to the same connection are put into the same nfqueue.
.SS NOTRACK
This target disables connection tracking for all packets matching that rule.
.PP
It can only be used in the
.B raw
table.
.SS RATEEST
The RATEEST target collects statistics, performs rate estimation calculation
and saves the results for later evaluation using the \fBrateest\fP match.
.TP
\fB\-\-rateest\-name\fP \fIname\fP
Count matched packets into the pool referred to by \fIname\fP, which is freely
choosable.
.TP
\fB\-\-rateest\-interval\fP \fIamount\fP{\fBs\fP|\fBms\fP|\fBus\fP}
Rate measurement interval, in seconds, milliseconds or microseconds.
.TP
\fB\-\-rateest\-ewmalog\fP \fIvalue\fP
Rate measurement averaging time constant.
.SS REJECT
This is used to send back an error packet in response to the matched
packet: otherwise it is equivalent to 
.B DROP
so it is a terminating TARGET, ending rule traversal.
This target is only valid in the
.BR INPUT ,
.B FORWARD
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  The following option controls the nature of the error packet
returned:
.TP
\fB\-\-reject\-with\fP \fItype\fP
The type given can be
\fBicmp6\-no\-route\fP,
\fBno\-route\fP,
\fBicmp6\-adm\-prohibited\fP,
\fBadm\-prohibited\fP,
\fBicmp6\-addr\-unreachable\fP,
\fBaddr\-unreach\fP,
\fBicmp6\-port\-unreachable\fP or
\fBport\-unreach\fP
which return the appropriate ICMPv6 error message (\fBport\-unreach\fP is
the default). Finally, the option
\fBtcp\-reset\fP
can be used on rules which only match the TCP protocol: this causes a
TCP RST packet to be sent back.  This is mainly useful for blocking 
.I ident
(113/tcp) probes which frequently occur when sending mail to broken mail
hosts (which won't accept your mail otherwise).
\fBtcp\-reset\fP
can only be used with kernel versions 2.6.14 or later.
.SS SECMARK
This is used to set the security mark value associated with the
packet for use by security subsystems such as SELinux.  It is only
valid in the
.B mangle
table. The mark is 32 bits wide.
.TP
\fB\-\-selctx\fP \fIsecurity_context\fP
.SS SET
This modules adds and/or deletes entries from IP sets which can be defined 
by ipset(8).
.TP
\fB\-\-add\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...]
add the address(es)/port(s) of the packet to the sets
.TP
\fB\-\-del\-set\fP \fIsetname\fP \fIflag\fP[\fB,\fP\fIflag\fP...]
delete the address(es)/port(s) of the packet from the sets
.IP
where flags are
.BR "src"
and/or
.BR "dst"
specifications and there can be no more than six of them.
.PP
Use of -j SET requires that ipset kernel support is provided. As standard
kernels do not ship this currently, the ipset or Xtables-addons package needs
to be installed.
.SS TCPMSS
This target allows to alter the MSS value of TCP SYN packets, to control
the maximum size for that connection (usually limiting it to your
outgoing interface's MTU minus 40 for IPv4 or 60 for IPv6, respectively).
Of course, it can only be used
in conjunction with
\fB\-p tcp\fP.
.PP
This target is used to overcome criminally braindead ISPs or servers
which block "ICMP Fragmentation Needed" or "ICMPv6 Packet Too Big"
packets.  The symptoms of this
problem are that everything works fine from your Linux
firewall/router, but machines behind it can never exchange large
packets:
.PD 0
.RS 0.1i
.TP 0.3i
1)
Web browsers connect, then hang with no data received.
.TP
2)
Small mail works fine, but large emails hang.
.TP
3)
ssh works fine, but scp hangs after initial handshaking.
.RE
.PD
Workaround: activate this option and add a rule to your firewall
configuration like:
.IP
 iptables \-t mangle \-A FORWARD \-p tcp \-\-tcp\-flags SYN,RST SYN
             \-j TCPMSS \-\-clamp\-mss\-to\-pmtu
.TP
\fB\-\-set\-mss\fP \fIvalue\fP
Explicitly sets MSS option to specified value. If the MSS of the packet is
already lower than \fIvalue\fP, it will \fBnot\fP be increased (from Linux
2.6.25 onwards) to avoid more problems with hosts relying on a proper MSS.
.TP
\fB\-\-clamp\-mss\-to\-pmtu\fP
Automatically clamp MSS value to (path_MTU \- 40 for IPv4; \-60 for IPv6).
This may not function as desired where asymmetric routes with differing
path MTU exist \(em the kernel uses the path MTU which it would use to send
packets from itself to the source and destination IP addresses. Prior to
Linux 2.6.25, only the path MTU to the destination IP address was
considered by this option; subsequent kernels also consider the path MTU
to the source IP address.
.PP
These options are mutually exclusive.
.SS TCPOPTSTRIP
This target will strip TCP options off a TCP packet. (It will actually replace
them by NO-OPs.) As such, you will need to add the \fB\-p tcp\fP parameters.
.TP
\fB\-\-strip\-options\fP \fIoption\fP[\fB,\fP\fIoption\fP...]
Strip the given option(s). The options may be specified by TCP option number or
by symbolic name. The list of recognized options can be obtained by calling
iptables with \fB\-j TCPOPTSTRIP \-h\fP.
.SS TEE
The \fBTEE\fP target will clone a packet and redirect this clone to another
machine on the \fBlocal\fP network segment. In other words, the nexthop
must be the target, or you will have to configure the nexthop to forward it
further if so desired.
.TP
\fB\-\-gateway\fP \fIipaddr\fP
Send the cloned packet to the host reachable at the given IP address.
Use of 0.0.0.0 (for IPv4 packets) or :: (IPv6) is invalid.
.PP
To forward all incoming traffic on eth0 to an Network Layer logging box:
.PP
\-t mangle \-A PREROUTING \-i eth0 \-j TEE \-\-gateway 2001:db8::1
.SS TOS
This module sets the Type of Service field in the IPv4 header (including the
"precedence" bits) or the Priority field in the IPv6 header. Note that TOS
shares the same bits as DSCP and ECN. The TOS target is only valid in the
\fBmangle\fP table.
.TP
\fB\-\-set\-tos\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fP and XORs \fIvalue\fP into the
TOS/Priority field. If \fImask\fP is omitted, 0xFF is assumed.
.TP
\fB\-\-set\-tos\fP \fIsymbol\fP
You can specify a symbolic name when using the TOS target for IPv4. It implies
a mask of 0xFF. The list of recognized TOS names can be obtained by calling
iptables with \fB\-j TOS \-h\fP.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-tos\fP \fIbits\fP
Binary AND the TOS value with \fIbits\fP. (Mnemonic for \fB\-\-set\-tos
0/\fP\fIinvbits\fP, where \fIinvbits\fP is the binary negation of \fIbits\fP.)
.TP
\fB\-\-or\-tos\fP \fIbits\fP
Binary OR the TOS value with \fIbits\fP. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fP\fB/\fP\fIbits\fP.)
.TP
\fB\-\-xor\-tos\fP \fIbits\fP
Binary XOR the TOS value with \fIbits\fP. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fP\fB/0\fP.)
.SS TRACE
This target marks packes so that the kernel will log every rule which match 
the packets as those traverse the tables, chains, rules. (The ipt_LOG or
ip6t_LOG module 
is required for the logging.) The packets are logged with the string prefix: 
"TRACE: tablename:chainname:type:rulenum " where type can be "rule" for 
plain rule, "return" for implicit rule at the end of a user defined chain 
and "policy" for the policy of the built in chains. 
.br
It can only be used in the
.BR raw
table.
